import { prisma } from "@/lib/prisma";
import { Card, CardBody, CardHeader, Button } from "@/components/ui";
import { approveKycAction, rejectKycAction } from "@/app/admin/actions";

export default async function AdminKyc() {
  const pending = await prisma.user.findMany({
    where: {
      OR: [{ kycLevel: "UNVERIFIED" }, { kycProfile: { is: { status: "PENDING" } } }],
    },
    orderBy: { createdAt: "desc" },
    take: 50,
    include: { kycProfile: true },
  });

  return (
    <Card>
      <CardHeader title="KYC" subtitle="Review queue (lite)" />
      <CardBody>
        <div className="grid gap-3">
          {pending.length === 0 ? <div className="text-sm text-zinc-600">No pending KYC.</div> : null}
          {pending.map((u) => (
            <div key={u.id} className="rounded-2xl border border-zinc-200 bg-white p-4">
              <div className="flex flex-wrap items-start justify-between gap-3">
                <div>
                  <div className="text-sm font-medium">{u.email}</div>
                  <div className="text-xs text-zinc-600">{u.fullName ?? "-"} • {u.phone ?? "-"}</div>
                  <div className="mt-2 text-xs text-zinc-600">
                    KYC level: <span className="font-medium">{u.kycLevel}</span>
                    {u.kycProfile ? (
                      <>
                        {" "}• status: <span className="font-medium">{u.kycProfile.status}</span>
                        {u.kycProfile.documentType ? ` • ${u.kycProfile.documentType}` : ""}
                        {u.kycProfile.documentNumber ? ` • ${u.kycProfile.documentNumber}` : ""}
                      </>
                    ) : null}
                  </div>
                </div>

                <div className="flex flex-col gap-2">
                  <form action={approveKycAction}>
                    <input type="hidden" name="userId" value={u.id} />
                    <Button type="submit" className="w-full">Approve FULL</Button>
                  </form>
                  <form action={rejectKycAction} className="grid gap-2">
                    <input type="hidden" name="userId" value={u.id} />
                    <input name="reason" placeholder="Reason (optional)" className="rounded-xl border border-zinc-200 px-3 py-2 text-sm" />
                    <Button type="submit" className="w-full">Reject</Button>
                  </form>
                </div>
              </div>
            </div>
          ))}
        </div>
      </CardBody>
    </Card>
  );
}
