import { ReactNode } from "react";
import { AdminNav } from "@/components/admin-nav";
import { requireRole } from "@/lib/requireRole";

export default async function AdminLayout({ children }: { children: ReactNode }) {
  await requireRole(["ADMIN"]);
  return (
    <>
      <AdminNav />
      <div className="mx-auto max-w-6xl px-4 py-6">{children}</div>
    </>
  );
}
