import { prisma } from "@/lib/prisma";
import { Card, CardBody, CardHeader } from "@/components/ui";

export default async function AdminRisk() {
  const events = await prisma.riskEvent.findMany({
    orderBy: { createdAt: "desc" },
    take: 100,
    include: { user: { select: { email: true } } },
  });

  return (
    <Card>
      <CardHeader title="Risk events" subtitle="Latest 100" />
      <CardBody>
        <div className="overflow-x-auto">
          <table className="w-full text-sm">
            <thead>
              <tr className="text-left text-zinc-600">
                <th className="py-2">Time</th>
                <th className="py-2">User</th>
                <th className="py-2">Type</th>
                <th className="py-2">Severity</th>
                <th className="py-2">Message</th>
              </tr>
            </thead>
            <tbody>
              {events.map((e) => (
                <tr key={e.id} className="border-t border-zinc-200">
                  <td className="py-2 whitespace-nowrap">{new Date(e.createdAt).toLocaleString()}</td>
                  <td className="py-2">{e.user?.email ?? "-"}</td>
                  <td className="py-2">{e.type}</td>
                  <td className="py-2">{e.severity}</td>
                  <td className="py-2">{e.message}</td>
                </tr>
              ))}
            </tbody>
          </table>
        </div>
      </CardBody>
    </Card>
  );
}
