import { prisma } from "@/lib/prisma";
import { Card, CardBody, CardHeader, Button } from "@/components/ui";
import { setUserRoleAction } from "@/app/admin/actions";

export default async function AdminUsers() {
  const users = await prisma.user.findMany({
    orderBy: { createdAt: "desc" },
    take: 50,
    select: { id: true, email: true, fullName: true, phone: true, role: true, kycLevel: true, createdAt: true },
  });

  return (
    <Card>
      <CardHeader title="Users" subtitle="Latest 50" />
      <CardBody>
        <div className="overflow-x-auto">
          <table className="w-full text-sm">
            <thead>
              <tr className="text-left text-zinc-600">
                <th className="py-2">Email</th>
                <th className="py-2">Name</th>
                <th className="py-2">Phone</th>
                <th className="py-2">Role</th>
                <th className="py-2">KYC</th>
                <th className="py-2">Action</th>
              </tr>
            </thead>
            <tbody>
              {users.map((u) => (
                <tr key={u.id} className="border-t border-zinc-200">
                  <td className="py-2">{u.email}</td>
                  <td className="py-2">{u.fullName ?? "-"}</td>
                  <td className="py-2">{u.phone ?? "-"}</td>
                  <td className="py-2">{u.role}</td>
                  <td className="py-2">{u.kycLevel}</td>
                  <td className="py-2">
                    <form action={setUserRoleAction} className="flex items-center gap-2">
                      <input type="hidden" name="userId" value={u.id} />
                      <select name="role" defaultValue={u.role} className="rounded-xl border border-zinc-200 bg-white px-2 py-1">
                        <option value="CONSUMER">CONSUMER</option>
                        <option value="MERCHANT">MERCHANT</option>
                        <option value="ADMIN">ADMIN</option>
                      </select>
                      <Button type="submit">Save</Button>
                    </form>
                  </td>
                </tr>
              ))}
            </tbody>
          </table>
        </div>
      </CardBody>
    </Card>
  );
}
