import { z } from "zod";
import { prisma } from "@/lib/prisma";

const BodySchema = z.object({
  phone: z.string().min(7).max(20),
});

function mainMenu() {
  return [
    "LEFA *555#",
    "1. Balance",
    "2. Send money",
    "3. Pay merchant",
    "4. Recent transactions",
    "5. KYC status",
    "0. Exit",
  ].join("\n");
}

export async function POST(req: Request) {
  const json = await req.json().catch(() => null);
  const parsed = BodySchema.safeParse(json);
  if (!parsed.success) return Response.json({ error: "INVALID_BODY" }, { status: 400 });

  const phone = parsed.data.phone.trim();
  const s = await prisma.ussdSession.create({
    data: {
      phone,
      lastMenu: "MAIN",
      state: { step: "MAIN" },
    },
  });

  return Response.json({ ok: true, sessionId: s.id, menu: mainMenu() });
}
