import { TopNav } from "@/components/nav";
import { Card, CardBody, CardHeader, Container } from "@/components/ui";
import { requireSession } from "@/lib/session";
import { prisma } from "@/lib/prisma";
import { KycPanel } from "@/components/kyc/KycPanel";

export default async function KycPage() {
  const session = await requireSession();
  const user = await prisma.user.findUnique({
    where: { id: session.uid },
    include: { kycProfile: true },
  });

  return (
    <>
      <TopNav />
      <Container>
        <div className="mx-auto max-w-2xl">
          <Card>
            <CardHeader title="KYC & Limits" subtitle="Upgrade your limits" />
            <CardBody>
              <KycPanel
                user={{
                  id: user!.id,
                  email: user!.email,
                  phone: user!.phone,
                  kycLevel: user!.kycLevel,
                  kycStatus: user!.kycProfile?.status ?? "NONE",
                  phoneVerifiedAt: user!.kycProfile?.phoneVerifiedAt ? user!.kycProfile.phoneVerifiedAt.toISOString() : null,
                }}
              />
            </CardBody>
          </Card>
        </div>
      </Container>
    </>
  );
}
