import { TopNav } from "@/components/nav";
import { Card, CardBody, CardHeader, Container } from "@/components/ui";
import { requireSession } from "@/lib/session";
import { requireMerchant } from "@/lib/role";
import { prisma } from "@/lib/prisma";
import { CreateKeyForm, RevokeKeyButton } from "./ApiKeyClient";

export default async function ApiKeysPage() {
  const session = await requireSession();
  await requireMerchant(session.uid);

  const keys = await prisma.apiKey.findMany({
    where: { userId: session.uid },
    orderBy: { createdAt: "desc" },
  });

  return (
    <>
      <TopNav />
      <Container>
        <div className="grid gap-6 md:grid-cols-2">
          <Card>
            <CardHeader title="API Keys" subtitle="Use these for e-commerce integrations" />
            <CardBody>
              <CreateKeyForm />
            </CardBody>
          </Card>

          <Card>
            <CardHeader title="Existing keys" subtitle="Hashes stored; key shown only once" />
            <CardBody>
              <div className="space-y-3">
                {keys.length === 0 ? (
                  <div className="text-sm text-zinc-600">No keys yet.</div>
                ) : (
                  keys.map((k) => (
                    <div key={k.id} className="rounded-xl border border-zinc-200 p-3">
                      <div className="flex items-center justify-between gap-3">
                        <div>
                          <div className="text-sm font-medium">{k.name}</div>
                          <div className="text-xs text-zinc-600">Created: {new Date(k.createdAt).toLocaleString()}</div>
                          {k.revokedAt ? (
                            <div className="mt-1 text-xs text-red-600">Revoked</div>
                          ) : (
                            <div className="mt-1 text-xs text-green-700">Active</div>
                          )}
                        </div>
                        {k.revokedAt ? null : <RevokeKeyButton id={k.id} />}
                      </div>
                    </div>
                  ))
                )}
              </div>
            </CardBody>
          </Card>
        </div>
      </Container>
    </>
  );
}
