import { TopNav } from "@/components/nav";
import { Card, CardBody, CardHeader, Container } from "@/components/ui";
import { requireSession } from "@/lib/session";
import { requireMerchant } from "@/lib/role";
import { prisma } from "@/lib/prisma";
import { fromMinor } from "@/lib/money";

export default async function MerchantPaymentsPage() {
  const session = await requireSession();
  const user = await requireMerchant(session.uid);

  const txs = await prisma.transaction.findMany({
    where: { toUserId: session.uid, type: "PAYMENT" },
    orderBy: { createdAt: "desc" },
    take: 50,
  });

  return (
    <>
      <TopNav />
      <Container>
        <Card>
          <CardHeader title="Payments" subtitle="Last 50 merchant payments" />
          <CardBody>
            <div className="space-y-3">
              {txs.length === 0 ? (
                <div className="text-sm text-zinc-600">No payments yet.</div>
              ) : (
                txs.map((t) => (
                  <div key={t.id} className="rounded-xl border border-zinc-200 px-3 py-2">
                    <div className="flex items-center justify-between">
                      <div>
                        <div className="text-sm font-medium">{t.description ?? "Payment"}</div>
                        <div className="text-xs text-zinc-600">{new Date(t.createdAt).toLocaleString()}</div>
                      </div>
                      <div className="text-sm font-semibold">P {fromMinor(t.amount)}</div>
                    </div>
                  </div>
                ))
              )}
            </div>
          </CardBody>
        </Card>
      </Container>
    </>
  );
}
