"use client";

import { useActionState, useState } from "react";
import { Button, Input, Label } from "@/components/ui";
import { createWebhookAction, disableWebhookAction } from "@/app/actions/merchant";

export function CreateWebhookForm() {
  const [state, action] = useActionState(createWebhookAction as any, { ok: false } as any);
  const [events, setEvents] = useState("payment_intent.succeeded");

  return (
    <form action={action} className="space-y-3">
      <div>
        <Label>Webhook URL</Label>
        <Input name="url" placeholder="https://yourdomain.com/webhooks/lefa" />
      </div>
      <div>
        <Label>Events (comma-separated)</Label>
        <input
          name="events"
          value={events}
          onChange={(e) => setEvents(e.target.value)}
          className="w-full rounded-xl border border-zinc-200 bg-white px-3 py-2 text-sm outline-none focus:border-zinc-400"
          placeholder="payment_intent.succeeded,payment_request.paid"
        />
        <div className="mt-1 text-xs text-zinc-600">Leave blank to receive all events.</div>
      </div>
      <Button type="submit" className="w-full">Add endpoint</Button>
      {state?.ok && state?.secret ? (
        <div className="rounded-xl border border-zinc-200 bg-zinc-50 p-3 text-xs">
          <div className="font-medium">Webhook secret (shown once)</div>
          <div className="mt-1 font-mono break-all">{state.secret}</div>
        </div>
      ) : null}
      {state?.ok === false && state?.error ? <div className="text-xs text-red-600">{state.error}</div> : null}
    </form>
  );
}

export function DisableWebhookButton({ id }: { id: string }) {
  const [state, action] = useActionState(disableWebhookAction as any, { ok: false } as any);

  return (
    <form action={action}>
      <input type="hidden" name="id" value={id} />
      <Button type="submit">Disable</Button>
      {state?.ok && <span className="ml-2 text-xs text-green-700">Done</span>}
    </form>
  );
}
