import { TopNav } from "@/components/nav";
import { Card, CardBody, CardHeader, Container } from "@/components/ui";
import { requireSession } from "@/lib/session";
import { QRClient } from "./QRClient";

export default async function QRPage() {
  const session = await requireSession();
  const baseUrl = process.env.NEXTAUTH_URL ?? "http://localhost:3000";

  return (
    <>
      <TopNav />
      <Container>
        <div className="grid gap-6 md:grid-cols-2">
          <Card>
            <CardHeader title="QR payment request" subtitle="Create a short link, share via QR / WhatsApp" />
            <CardBody>
              <div className="text-sm text-zinc-700">
                Use this for market stalls, taxis, informal shops and events.
              </div>
              <div className="mt-4">
                <QRClient baseUrl={baseUrl} />
              </div>
            </CardBody>
          </Card>

          <Card>
            <CardHeader title="How it works" subtitle="Customer scans, confirms, pays instantly" />
            <CardBody>
              <ol className="list-decimal space-y-2 pl-5 text-sm text-zinc-700">
                <li>You create a request (amount + reference).</li>
                <li>LEFA generates a short pay link and QR.</li>
                <li>Customer opens the link (web or lite app), signs in, pays.</li>
                <li>Merchant/receiver sees the transaction immediately.</li>
              </ol>
              <div className="mt-4 text-xs text-zinc-500">
                Next: QR scan in-app, tap-to-pay, and external wallet/bank connectors.
              </div>
            </CardBody>
          </Card>
        </div>
      </Container>
    </>
  );
}
