"use client";

import { useFormState } from "react-dom";
import { sendMoneyAction } from "@/app/actions/wallet";
import { Button, Input, Label } from "@/components/ui";

export function SendForm() {
  const [state, action] = useFormState(sendMoneyAction as any, null);

  return (
    <form action={action} className="space-y-4">
      <div>
        <Label>Recipient email</Label>
        <Input name="toEmail" type="email" placeholder="recipient@example.com" />
      </div>
      <div>
        <Label>Amount (BWP)</Label>
        <Input name="amount" type="number" placeholder="50" />
      </div>
      <div>
        <Label>Description (optional)</Label>
        <Input name="description" type="text" placeholder="Lunch" />
      </div>
      {state?.ok === false ? (
        <div className="text-sm text-red-600">{state.error}</div>
      ) : state?.ok ? (
        <div className="text-sm text-green-700">Sent. TX: {state.txId}</div>
      ) : null}
      <Button type="submit" className="w-full">Send</Button>
    </form>
  );
}
