"use client";

import { useState } from "react";
import { Card, CardBody, CardHeader, Container, Button } from "@/components/ui";

export default function UssdSim() {
  const [phone, setPhone] = useState("+26770000001");
  const [sessionId, setSessionId] = useState<string | null>(null);
  const [menu, setMenu] = useState<string>("Dial *555# to begin");
  const [input, setInput] = useState("");
  const [busy, setBusy] = useState(false);

  async function start() {
    setBusy(true);
    try {
      const res = await fetch("/api/ussd/start", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ phone }),
      });
      const j = await res.json();
      if (!res.ok) throw new Error(j.error ?? "FAILED");
      setSessionId(j.sessionId);
      setMenu(j.menu);
      setInput("");
    } finally {
      setBusy(false);
    }
  }

  async function step() {
    if (!sessionId) return;
    setBusy(true);
    try {
      const res = await fetch("/api/ussd/step", {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify({ sessionId, input }),
      });
      const j = await res.json();
      if (!res.ok) throw new Error(j.error ?? "FAILED");
      setMenu(j.menu);
      setInput("");
    } finally {
      setBusy(false);
    }
  }

  return (
    <Container>
      <div className="mx-auto max-w-xl">
        <Card>
          <CardHeader title="USSD Simulator" subtitle="LEFA *555# (web simulation)" />
          <CardBody>
            <div className="grid gap-3">
              <div>
                <div className="mb-1 text-xs font-medium text-zinc-700">Phone</div>
                <input
                  value={phone}
                  onChange={(e) => setPhone(e.target.value)}
                  className="w-full rounded-xl border border-zinc-200 bg-white px-3 py-2 text-sm"
                />
              </div>
              <Button onClick={start} disabled={busy}>Dial *555#</Button>

              <div className="rounded-2xl border border-zinc-200 bg-zinc-50 p-4 font-mono text-sm whitespace-pre-wrap">
                {menu}
              </div>

              <div className="flex items-center gap-2">
                <input
                  value={input}
                  onChange={(e) => setInput(e.target.value)}
                  placeholder="Enter option / value"
                  className="flex-1 rounded-xl border border-zinc-200 bg-white px-3 py-2 text-sm"
                />
                <Button onClick={step} disabled={busy || !sessionId}>Send</Button>
              </div>
              <div className="text-xs text-zinc-600">
                Menus implemented: Balance, Recent, Send (by email), Pay merchant (by merchant email), KYC status.
              </div>
            </div>
          </CardBody>
        </Card>
      </div>
    </Container>
  );
}
