"use client";

import Link from "next/link";
import { usePathname } from "next/navigation";
import clsx from "clsx";

export function AdminNav() {
  const pathname = usePathname();

  const items = [
    { href: "/admin", label: "Overview" },
    { href: "/admin/users", label: "Users" },
    { href: "/admin/kyc", label: "KYC" },
    { href: "/admin/risk", label: "Risk" },
    { href: "/admin/disputes", label: "Disputes" },
  ];

  return (
    <div className="border-b border-zinc-200 bg-white">
      <div className="mx-auto flex max-w-6xl items-center justify-between px-4 py-3">
        <Link href="/admin" className="text-sm font-semibold tracking-tight">
          LEFA Admin
        </Link>
        <div className="flex flex-wrap items-center gap-2">
          {items.map((it) => (
            <Link
              key={it.href}
              href={it.href}
              className={clsx(
                "rounded-xl px-3 py-2 text-sm",
                pathname === it.href || pathname.startsWith(it.href + "/")
                  ? "bg-zinc-900 text-white"
                  : "text-zinc-700 hover:bg-zinc-100"
              )}
            >
              {it.label}
            </Link>
          ))}
        </div>
      </div>
    </div>
  );
}
