export type ExternalProvider = "orange_money" | "smega" | "my_zaka" | "bank";

export type LinkedAccount = {
  provider: ExternalProvider;
  externalRef: string;
  displayName: string;
  masked: string;
};

export async function linkExternalAccount(_params: {
  provider: ExternalProvider;
  phoneOrAccount: string;
}): Promise<LinkedAccount> {
  return {
    provider: _params.provider,
    externalRef: `mock_${Math.random().toString(16).slice(2)}`,
    displayName: `${_params.provider.toUpperCase()} account`,
    masked: "****" + _params.phoneOrAccount.slice(-4),
  };
}
