import type { ProviderAdapter, ProviderInitResult, ProviderName } from "./types";

function fakeExternalRef(prefix: string) {
  return `${prefix}_${Math.random().toString(36).slice(2, 10)}${Date.now().toString(36)}`.toUpperCase();
}

function ok(prefix: string, extra?: Partial<ProviderInitResult>): ProviderInitResult {
  return { externalRef: fakeExternalRef(prefix), status: "SUCCEEDED", ...extra };
}

/**
 * These adapters are intentionally *stubs*.
 * They provide clean integration points where real partner APIs will be wired.
 */
export const OrangeMoneyAdapter: ProviderAdapter = {
  name: "ORANGE_MONEY",
  displayName: "Orange Money",
  async initiate() {
    return ok("OM");
  },
};

export const SmegaAdapter: ProviderAdapter = {
  name: "SMEGA",
  displayName: "Smega",
  async initiate() {
    return ok("SMEGA");
  },
};

export const MyZakaAdapter: ProviderAdapter = {
  name: "MY_ZAKA",
  displayName: "My Zaka",
  async initiate() {
    return ok("MZ");
  },
};

export const BankAdapter: ProviderAdapter = {
  name: "BANK",
  displayName: "Bank Transfer",
  async initiate() {
    return ok("BANK");
  },
};

export const PROVIDERS: ProviderAdapter[] = [OrangeMoneyAdapter, SmegaAdapter, MyZakaAdapter, BankAdapter];

export function getProvider(name: ProviderName) {
  const p = PROVIDERS.find((x) => x.name === name);
  if (!p) throw new Error("UNKNOWN_PROVIDER");
  return p;
}
