export type ProviderName = "ORANGE_MONEY" | "SMEGA" | "MY_ZAKA" | "BANK";

export type ExternalTransferType = "TOPUP" | "WITHDRAWAL";

export type ProviderInitResult = {
  externalRef: string;
  status: "PENDING" | "SUCCEEDED" | "FAILED";
  message?: string;
  meta?: Record<string, any>;
};

export interface ProviderAdapter {
  name: ProviderName;
  displayName: string;
  initiate(params: {
    type: ExternalTransferType;
    phoneOrAccount: string;
    amountMinor: bigint;
    currency: string;
    reference: string;
  }): Promise<ProviderInitResult>;
}
