import { cookies } from "next/headers";

const COOKIE_NAME = "lefa_guest";

export type GuestSession = {
  guestId: string;
  phone?: string;
  email?: string;
};

export function getGuestSession(): GuestSession | null {
  const c = cookies().get(COOKIE_NAME)?.value;
  if (!c) return null;
  try {
    const parsed = JSON.parse(Buffer.from(c, "base64url").toString("utf8"));
    if (!parsed?.guestId) return null;
    return parsed as GuestSession;
  } catch {
    return null;
  }
}

export function setGuestSession(session: GuestSession) {
  const value = Buffer.from(JSON.stringify(session), "utf8").toString("base64url");
  cookies().set(COOKIE_NAME, value, {
    httpOnly: true,
    sameSite: "lax",
    secure: process.env.NODE_ENV === "production",
    path: "/",
    maxAge: 60 * 60 * 24 * 7,
  });
}

export function clearGuestSession() {
  cookies().delete(COOKIE_NAME);
}
