export function toMinor(amountMajor: number): bigint {
  // BWP minor units: thebe (2 dp)
  return BigInt(Math.round(amountMajor * 100));
}

export function fromMinor(amountMinor: bigint): string {
  const sign = amountMinor < 0n ? "-" : "";
  const abs = amountMinor < 0n ? -amountMinor : amountMinor;
  const major = abs / 100n;
  const minor = abs % 100n;
  return `${sign}${major.toString()}.${minor.toString().padStart(2, "0")}`;
}
