export type ProviderChargeRequest = {
  amountMinor: bigint;
  currency: string;
  reference: string;
  description?: string;
  payer?: { phone?: string; email?: string };
};

export type ProviderPayoutRequest = {
  amountMinor: bigint;
  currency: string;
  reference: string;
  beneficiary: { bankCode?: string; accountNumber?: string; phone?: string };
};

export type ProviderResult = {
  provider: string;
  providerRef: string;
  status: "PENDING" | "SUCCEEDED" | "FAILED";
  raw?: any;
};

export interface ProviderAdapter {
  name: string;
  createCharge(req: ProviderChargeRequest): Promise<ProviderResult>;
  createPayout(req: ProviderPayoutRequest): Promise<ProviderResult>;
  getStatus(providerRef: string): Promise<ProviderResult>;
}
