import { getServerSession } from "next-auth";
import { authOptions } from "@/lib/auth";

export async function requireSession() {
  const session = await getServerSession(authOptions);
  if (!session || !(session as any).uid) {
    throw new Error("UNAUTHENTICATED");
  }
  return session as any;
}

export async function getSessionOptional() {
  const session = await getServerSession(authOptions);
  if (!session || !(session as any).uid) return null;
  return session as any;
}
